﻿/*==============================================================================================
   HTML Parsing Blocks. The following vars contain HTML code to be inserted in the Register
   Today HTML pages based on the business logic, e.g., whether the registration is for a company
   or individual, whether an old serial number is needed, whether State/Region/Province is 
   required, etc.

   (C) Copyright 2004 by Autodesk, Inc.  All rights reserved.
  ==============================================================================================*/

/////////////////////////////////////////////
// LOCALIZATION RESOURCES HERE:
/////////////////////////////////////////////

/////////////////////////////////////////////
// Product Language: 
//
// NOTE TO LOCALIZATION: The list below was inserted on 29 Jan 2001 and it was up to date at that point.
// You may use the codes detailed below if you are sure that these have not changed (they generally don't change), otherwise, 
// please check these before inserting the language code.
/////////////////////////////////////////////
//
//English - US and International:  (en-us)
//German:  (de)
//French:   (fr)
//Italian:   (it)
//Spanish:   (es)
//Czech:   (cs)             
//Hungarian:   (hu)
//Polish:   (pl)
//Russian:   (ru)
//Japanese:   (ja)
//Korean:   (ko)
//Traditional Chinese (Taiwan) :   (zh-tw)
//Simplified Chinese (PRC) :   (zh-cn)
//Brazilian Portuguese (pt-br)
//
/////////////////////////////////////////////

//////////////////////////////////////////////
///// Add as ECO17 Direct Addition to the Privacy Policy 
/////
var xmsgGatherInfoDuringInstall= "Należy zauważyć, że wszystkie dane zebrane podczas aktywacji produktu będą używane zgodnie z zasadami firmy Autodesk ";
var xmsgOfflinePrivacyWarning= "Jeśli twój komputer nie jest połączony z Internetem, możesz wyświetlić zasady zachowania poufności poprzez ustawienie sposobu kodowania programu Internet Explorer (R) na tryb Wybór automatyczny. Jeśli twój komputer jest połączony z Internetem, zasady zachowania poufności można również znaleźć online w witrynie www.autodesk.com."
////////////////////////////////////////////////////

var xmsgProductLanguage=	"pl";

/////////////////////////////////////////////
// Disable field color
/////////////////////////////////////////////
var xmsgDisableColor=		"#7f7f7f";

var xmsgNavigationBGColor=	"#f4f4f4";
var xmsgNavigationDisableColor=	"#808080";

/////////////////////////////////////////////
// HTML FILE TITLE STRINGS
/////////////////////////////////////////////
var xmsgRTAuthConfirmed=				"Autoryzacja potwierdzona";
var xmsgRTActLicFound=                  "Znaleziono aktywowaną licencję";
var xmsgRTActLicFoundError=            "Błąd rejestracji-aktywacji"; 
var xmsgRTAuthEntryError=				"Błąd wprowadzania aktywacji";
var xmsgRTAuthError=					"Błąd aktywacji";
var xmsgRTAuthNow=						"Autoryzuj teraz";
var xmsgRTBeginReg=						"Rozpocznij rejestrację";
var xmsgRTBuyInformation=				"Informacje dotyczące zakupu";
var xmsgRTConfirm=						"Potwierdzenie przez użytkownika";
var xmsgRTConnect=						"Połącz";
var xmsgRTConnectFail=					"Błąd połączenia";
var xmsgRTContactAutodesk=				"Skontaktuj się z Autodesk";
var xmsgRTCountryPage=					"Kraj";
var xmsgRTEmail=						"Poczta elektroniczna";
var xmsgRTFaxUS=						"Rejestracja poprzez faks";
var xmsgRTMailUS=						"Rejestracja pocztowa";
var xmsgRTPurchaseOffline=				"Zakup w trybie offline";
var xmsgRTRegConfirmed=					"Rejestracja potwierdzona";
var xmsgRTExportConfirm=                "Potwierdzenie eksportowania licencji";
var xmsgRTImportConfirm=                "Potwierdzenie importowania licencji"; 
var xmsgRTRegVol=						"Zarejestruj produkt";
var xmsgRTSUNDataConfirm=				"Potwierdzenie danych SUN";
var xmsgRTSUNServer=					"Serwer SUN";
var xmsgRTSUNSubmit=					"Potwierdzenie/przesłanie SUN przez użytkownika";
var xmsgRTUserInfo=						"Informacje o użytkowniku";
var xmsgRTLicFileSaveError=				"Błąd zapisu pliku licencji Flexlm";
var xmsgRTProductInfo=                   "Informacje o produkcie"; //add by joyce.min on 2007-8-14
var xmsgNSARTBegin=						"Uzyskanie licencji sieciowej";
var xmsgNSARTLocateLicense=				"Lokalizacja pliku licencji";
var xmsgNSARTEditServerAndSeat=			"Podaj lub zmodyfikuj informacje o serwerze";
var xmsgNSARTConfirmServerAndSeat=		"Potwierdź informacje o serwerze";
var xmsgNSARTEnterSN=					"Podaj numer seryjny";
var xmsgProcessingError=				"Błąd przetwarzania";
var xmsgTimeout=        				"Upłynął limit czasu sesji";

/////////////////////////////////////////////
// Software Information RESOURCES HERE:
/////////////////////////////////////////////
var xmsgActivationFor=	"Aktywacja dla:";
var xmsgPurchase=       "Zakup:";
var xmsgRegistrationFor=       "Rejestracja dla:";
var xmsgProduct=	"Produkt: ";
var xmsgsernum=		"Numer seryjny: ";
var xmsgsernumWGID=	"Numer seryjny lub ID grupy: ";//modify by joyce.min on 2007-8-16
var xmsgprokeyWGID=  "Klucz produktu: "; // add by  joyce.min on 2007-8-16
var xmsgOsernum=	"Stary numer seryjny: ";
//var xmsgOprokey=      "Previous product key: "; // add by joyce.min on 2007-8-17
var xmsgOldSerialNum=	"Stary numer seryjny:*";
var xmsgNewSernum1=	"Wprowadź numer seryjny lub ID grupy:"; //???
//var xmsgNewProkey1=
var xmsgRequestCode=	"Kod żądania: ";
var xmsgRegAuthCode=	"Kod aktywacji: ";
var xmsgApplicationKey=	"Klucz aplikacji: ";
var xmsgRTHostID=				"ID hosta:";
var xmsgRTFlexlmLicenseFile=	"Plik licencji:";

/////////////////////////////////////////////
// Primary Rolodex RESOURCES HERE:
/////////////////////////////////////////////
var xmsgSalutation=	"Tytuł:";
var xmsgNone=		"(brak)";
var xmsgNotEntered=	"(nie podano)";
var xmsgFirstname=	"Imię:";
//var xmsgFirstname= langCode+label.fname;
var xmsgFirstnameKanji=	"Imię (Kanji):";
var xmsgFirstnameFurigana=	"Imię (Zenkaku Kana):";
var xmsgLastname=	"Nazwisko:";
var xmsgLastnameKanji=	"Nazwisko (Kanji):";
var xmsgLastnameFurigana=	"Nazwisko (Zenkaku Kana):";
var xmsgCompanyName=	"Nazwa firmy:*";
var xmsgCompanyName2=	"Nazwa firmy:";
var xmsgCompanyNameJP=	"Nazwa firmy (Kanji):";
var xmsgPhone=		"Telefon:";
var xmsgArea=		"Obszar:";
var xmsgNumber=		"Numer:";
var xmsgExt=		"Wewnętrzny:";
var xmsgFax=		"Faks:";
var xmsgFaxTo=		"Faks do ";
var xmsgEmail=		"Email:";
var xmsgEmailTo=	"Email do ";
var xmsgAddress=	"Ulica:";
var xmsgAddress2=	"Ulica 2:";
var xmsgAddress3=	"Ulica 3:";
var xmsgJPAddress=	"Miasto:";
var xmsgJPAddress2=	"Ulica:";
var xmsgJPAddress3=	"Nazwa budynku (i numer lokalu):";
var xmsgCity=		"Miasto:";
var xmsgSRP=		"Województwo/Powiat/Region:";
var xmsgStText=		"Województwo:";
var xmsgPrText=		"Powiat:";
var xmsgRegText=	"Region:";
var xmsgPrefectureText=	"Prefektura:";
var xmsgCountyText=	"Kraj:";
var xmsgCantonText=	"Kanton:";
var xmsgZipCode=	"Kod pocztowy:";
var xmsgPostCode=	"Kod pocztowy:";
var xmsgCountry=	"Kraj lub region:";
var xmsgDealer=		"Nazwa Autoryzowanego Sprzedawcy Autodesk:";
var xmsgMailTo=		"Wyślij ";
var xmsgAnEmail=	"adres email";
var xmsgAFax=		"numer faksu";
var xmsgAMailAddress=	"adres pocztowy";
var xmsgPostalMail=		"Poczta tradycyjna";

///////////////////////////////////////////////
// Button RESOURCES HERE:
///////////////////////////////////////////////
var xmsgBack=			"<< Wstecz";
var xmsgCancel=			"Zamknij";
var xmsgNext=			"Dalej >>";
var xmsgPrint=			"Drukuj";
var xmsgPrintForm=		"Otwórz formularz zgłoszenia aktywacji";
var xmsgNo=				"Nie";
var xmsgYes=			"Tak";
var xmsgBrowse=			"Przeglądaj";
var xmsgDone=			"Koniec";
var xmsgOK=				"OK";
var xmsgClose=			"Zamknij";
var xmsgSubmit=			"Wyślij";
var xmsgFinish=			"Zakończ";
var xmsgReset=			"Wyczyść wszystkie";

///////////////////////////////////////////////
// Registration User Prompt RESOURCES HERE:
///////////////////////////////////////////////
var xmsgPleaseSelect=		"Proszę wybrać ";
var xmsgPleaseSelect2=		"Wybierz jedną z poniższych opcji i kliknij Dalej.";
var xmsgSelectCountry=		"Kraj/region, w którym produkt będzie używany:";
var xmsgSelectCountry2=		"Kraj/region:";
var xmsgInformation=		"Informacje";
var xmsgCompanyInfo=		"Informacje dotyczące firmy:";
var xmsgContactInfo=		"Informacje kontaktowe:";
var xmsgResponseMethodInfo=	"Informacje o metodzie odpowiedzi:"; //modify as the Spec. recommond by joyce.min on 2007-8-17
var xmsgFormSubmitMethodInfo=	"Metoda wysyłania formularzy:";
var xmsgConfirmInfo=		"Potwierdź informacje";
var xmsgConfirmInfoTxt=		"Przejrzyj następujące informacje. Kliknij jedno z łączy metod wysyłania formularzy, aby kontynuować z użyciem tych informacji, lub kliknij przycisk Wstecz, aby wprowadzić zmiany.";
var xmsgConfirmCustIDInfoTxt=		"Sprawdź poniższe informacje. Kliknij Dalej by kontynuować lub Wstecz by wprowadzić zmiany.";
var xmsgCountryHdr=			"Rejestracja produktu";
var xmsgCountryRegTo=		"Ten produkt będzie zarejestrowany dla:";
var xmsgCountryComp=		"Na firmę";
var xmsgCountryIndiv=		"Indywidualnie";
var xmsgCountryUpgrade=		"To jest uaktualnienie";
var xmsgCountryUpgDetail=	"(Jeżeli jesteś użytkownikiem subskrypcji, kliknij Nie)";
var xmsgConnectHdr1=		"Łączenie";
var xmsgConnectHdr=		"Łączenie z internetem";
var xmsgConnectMsg=		"Połączenie";
var xmsgConnectTxt=		"Nie wykryto połączenia z internetem. Aby wysłać bezpośrednio zgłoszenie aktywacji, połącz się teraz z internetem.";
var xmsgConnectTxtOLT=    "Nie wykryto połączenia z Internetem. Aby przenieść licencję, połącz się z Internetem.";
var xmsgConnectTxt2=	"Gdy połączenie z internetem zostanie ustalone, kliknij Dalej.";
var xmsgConnectTxt3=	"Aby inaczej wysłać zgłoszenie aktywacji, kliknij poniższy odnośnik:";
var xmsgConnectWarming=	"Wysyłanie tych danych może potrwać kilka minut. Proszę czekać.";
var xmsgTryAgain=		"Spróbuj ponownie";
var xmsgReEnterOld=		"Wprowadź ponownie poprzedni numer seryjny";
var xmsgNewSernum3=		"Proszę wprowadzić nowy numer seryjny i kliknąć Dalej.";
var xmsgNewSernum4=		"Wersja próbna oprogramowania jest zainstalowana z numerem seryjnym (000-00000000), który nie może być zarejestrowany. Jeśli zakupisz kopię tego oprogramowania, uzyskasz nowy numer seryjny. Musisz użyć tego numeru, aby dokonać aktywacji i odblokować produkt do użytku.";
var xmsgNewSernum5=		"Wprowadź numer seryjny lub ID grupy:"; //modify by joyce.min on 2007-8-16
var xmsgProductKey=      "Wprowadź klucz produktu:"; //modify by joyce.min on 2007-8-16
var xmsgNewSernum6=		"Potwierdź nowy numer seryjny:";
var xmsgNewSernum8=		"Wprowadź ponownie nowy numer seryjny";
var xmsgUseOtherMethod=		"Skorzystaj z innej metody rejestracji";
var xmsgContactAutodesk=	"Skontaktuj się z Autodesk";
var xmsgContactAutodeskLink="Aby skontaktować się z firmą Autodesk, kliknij poniższy odnośnik:";
var xmsgContactOptions=		"Opcje kontaktu są pokazane poniżej.";

var xmsgPuchaseInfo1=		"Informacje dotyczące zakupu";
var xmsgPuchaseInfo2=		"Został wybrany zakup bezpośredni."; //modify as the LF1_Spec_SCV commend on p99 by joyce.min
var xmsgPuchaseInfo3=		"Kliknij przycisk Dalej, aby kontynuować, lub kliknij przycisk Anuluj, jeśli chcesz zrezygnować."; //modify as the LF1_Spec_SCV commend on p99 by joyce.min

var xmsgRegTitle=		"Rejestracja-aktywacja";
var xmsgRegTitleBuy=		"Zakup bezpośredni produktów firmy Autodesk";
var xmsgRegTitleNSA=		"Aktywacja licencji sieciowej";
var xmsgRegInfo=		"Informacje o użytkowniku";
var xmsgRegInfo2=		"Metoda rejestracji";
var xmsgRegInfo3=		"Proszę wybrać metodę rejestracji i kliknąć Dalej.";
var xmsgRegmethod1=		"Połącz bezpośrednio poprzez Internet";
var xmsgRegmethod3=		"Chciałbym otrzymać mój kod aktywacji:";
var xmsgRegmethod5=		"Pocztą";
var xmsgRegmethod6=		"Kliknij przycisk Drukuj znajdujący się poniżej i wyślij ten formularz do:";
var xmsgRegmethod7=		"Faksem";
var xmsgRegmethod8=		"Aby wydrukować formularz, który można wysłać faksem do firmy Autodesk na %1, należy najpierw wybrać sposób, w jaki zostanie odebrany kod aktywacji. Następnie kliknąć Drukuj. Teraz można przefaksować ten formularz.";
var xmsgRegmethod9=		"Pocztą elektroniczną";
var xmsgRegmethod10NSA=		"Twoje dane rejestracyjne i serwera licencji (przedstawione poniżej) zostały automatycznie zapisane w pliku.";
var xmsgRegmethod10=		"Twoje dane rejestracyjne (przedstawione poniżej) zostały automatycznie zapisane w poniższym pliku, który zostanie użyty do zakończenia procesu.";
var xmsgRegmethod11NSA=		"Wyślij pocztą elektroniczną plik %1 danych rejestracyjnych i serwera licencji do %2.<br>";
var xmsgRegmethod11=		"Wyślij pocztą elektroniczną plik danych rejestracyjnych %1 do %2.";
var xmsgRegmethod12=		"Upewnij się, że nie plik nie został zmodyfikowany.<p> Zalecane jest wydrukowanie kopii tej strony i przechowywanie jej w bezpiecznym miejscu. Informacje te będą potrzebne do ręcznego zakończenia procesu. <p>Można wydrukować kopię tych informacji. Kliknij przycisk Koniec, aby zamknąć tę aplikację.";
var xmsgRegmethod13=		"Aby automatycznie dołączyć i wysłać %1 do Autodesk, kliknij poniższy odnośnik.";
var xmsgRegmethod14=		"Wyślij zgłoszenie pocztą e-mail";
var xmsgRegmethod15=		"Uwaga: Ten adres email jest obsługiwany automatycznie. Proszę nie kontaktować się na ten adres.";
var xmsgRegmethod16=		"Aby zarejestrować wysyłając faks lub list, kliknij jeden z poniższych odnośników:";
var xmsgRegmethod17=		"Błąd wysyłania e-mail";
var xmsgRegmethod18NSA=		"Wystąpił błąd podczas próby automatycznego wysłania danych rejestracyjnych i serwera licencji.";
var xmsgRegmethod18=		"Wystąpił błąd podczas próby automatycznego wysłania danych rejestracyjnych.";
var xmsgRegmethod19=		"Aby samodzielnie wysłać e-mail:";
var xmsgRegmethod20NSA=		"Wyślij pocztą elektroniczną rejestrację i plik informacji o serwerze %1 do %2.<br>";
var xmsgRegmethod20=		"Wyślij pocztą elektroniczną plik danych rejestracyjnych %1 do %2.";
var xmsgRegmethod21=		"Upewnij się, że nie plik nie został zmodyfikowany .<p> Zalecane jest wydrukowanie kopii tej strony i przechowywanie jej w bezpiecznym miejscu. Informacje te będą potrzebne do ręcznego zakończenia procesu. <p>Można wydrukować kopię tych informacji. Kliknij przycisk Koniec, aby zamknąć tę aplikację.";
var xmsgRegAuthInfo=		"Aktywacja";
var xmsgRegAuthInfo1=		"Potwierdzenie rejestracji";
var xmsgRegExpConfirm=      "Potwierdzenie eksportowania licencji";
var xmsgRegImpConfirm=      "Potwierdzenie importowania licencji";
var xmsgRegAuthInfo2=		"Pobierz kod aktywacji";
var xmsgRegAuthInfo3=		"Podaj kod aktywacji"; 
var xmsgRegAuthInfo4=		"Wybierz jedną z opcji poniżej:";
var xmsgRegAuthInfo4A=		"Podaj kod aktywacji";
var xmsgRegAuthInfo4B=		"Podaj kod aktywacji:"; 
var xmsgRegAuthInfo5=		"Proszę wybrać kraj lub region, wprowadzić kod aktywacji i kliknąć Dalej.";
var xmsgRegAuthInfo6=		"Potwierdzenie rejestracji-aktywacji";	
var xmsgRegAuthInfo7=		"Dziękujemy za rejestrację i aktywację produktu.";
var xmsgRegAuthInfo8=		"Potwierdzenie";		
var xmsgRegAuthInfo9=		"Dziękujemy za rejestrację produktu Autodesk. Informacje te pomogą nam w przyszłości.";
var xmsgRegAuthInfo10=		"Kopia danych rejestracyjnych została także zapisana w:";		
var xmsgRegAuthInfo10B=		"Kopia danych rejestracyjnych została także zapisana w:";
var xmsgRegActLicInfo=      "Znaleziono aktywowaną licencję";
var xmsgRegActLicInfoError=      "Błąd rejestracji-aktywacji";
var xmsgRegActiveInfo=        "Wpisz ścieżkę pliku aktywacji lub zlokalizuj go:";
var xmsgRegActLicInfo1=       "Na komputerze została znaleziona wcześniej zarejestrowana i aktywowana licencja na ten produkt. Dziękujemy."
var xmsgRegActLicInfo1Error= "Na komputerze została znaleziona wcześniej zarejestrowana i aktywowana licencja na ten produkt.\n Wystąpił jednak nieoczekiwany błąd  (%1). Zamknij aplikację i spróbuj ponownie. Jeśli ten problem będzie nadal występował, skontaktuj się z administratorem systemu lub autoryzowanym sprzedawcą produktów Autodesk.";

/////////////////////////////////////////////
// OLT Confirmation
/////////////////////////////////////////////
var xmsgExportSuccess=        "Eksportowanie powiodło się"; //2008-01-16
var xmsgExportFail=           "Eksportowanie nie powiodło się" ; //2008-01-16
var xmsgRegErrRef=            "Numer błędu:"; //2008-01-17
var xmsgImportSuccess=        "Importowanie powiodło się"; //2008-01-16
var xmsgImportFail=           "Importowanie nie powiodło się"; //2008-01-16
var xmsgExpSucessInfo=        "Licencja została wyeksportowana i znajduje się teraz na serwerze firmy Autodesk."; //2008-01-16
var xmsgExpSuccessInfoHowtoImport=    "Jak zaimportować licencję";
var xmsgExpSucessInfo1=        "Przed uruchomieniem produktu na komputerze docelowym użyj narzędzia do przenoszenia licencji, aby zaimportować do niego tę licencję, i przygotuj się na wprowadzenie swojego identyfikatora użytkownika i hasła do serwera firmy Autodesk.";  //2008-01-16
var xmsgImpSucessInfo=         "Licencja została zaimportowana; możesz już korzystać z tego produktu. "; //2008-01-16
var xmsgImpRemindInfo=         "Przypomnij mi, aby wyeksportować."; //2008-01-16
var xmsgImpRemindInfo1=        "Zaznaczenie tego pola wyboru spowoduje, że każdorazowo podczas zamykania produktu wyświetlane będzie okno przypominające o konieczności wyeksportowania licencji.";//copy mockup 2008-01-16
var xmsgImpRemindInfo2=        "Jest to pomocne, jeśli importujesz licencję do tego komputera tymczasowo i będzie trzeba ją przenieść z powrotem.";//copy mockup 2008-01-16
var xmsgImpRemindInfo3=        "W przypomnieniu jest dostępna opcja \"Nie pokazuj tego komunikatu ponownie\".";//copy mockup 2008-01-16
var xmsgOltTryAgain=           "Kliknij przycisk \"Spróbuj ponownie\", aby przesłać ponownie żądanie. ";
var xmsgImpFailMsg=            "Jeśli problem będzie występował nadal, należy aktywować licencję zamiast ją importować.";

var xmsgReqfilelocMsg=       "Plik żądania znajduje się w następującej lokalizacji:";	//add by joyce.min on 2007-9-10 as Licensing Spec. recommend 	
var xmsgRegAuthInfo11=		"Dziękujemy za rejestrację - Twój produkt jest teraz aktywowany, a plik licencji zapisany. Kliknij Drukuj, aby zachować te informacje.";
var xmsgRegAuthInfo12=		"Wklej kod aktywacji.";
var xmsgRegAuthInfo13=		"Wpisz kod aktywacji.";
var xmsgRegErrorActiveCode=    "<FONT color=red>Wprowadź kod aktywacji, aby kontynuować.</FONT>";
var xmsgRegErrorActiveCode1=    "<FONT color=red>Kod aktywacji jest niepoprawny. Sprawdź, czy kod nie zawiera błędów.</FONT>";
var xmsgRegErrorActiveFile=    "<FONT color=red>Wprowadź nazwę i ścieżkę pliku aktywacji, aby przejść dalej.</FONT>";
var xmsgRegErrorSernum=      "<FONT color=red>Wprowadź numer seryjny, aby przejść dalej.</FONT>"; //add by joyce.min on 2007-8-29
var xmsgRegErrorSernum1=      "<FONT color=red>Numer seryjny jest zbyt krótki.</FONT>"; //add by joyce.min on 2007-9-7
var xmsgRegErrorProkey=      "<FONT color=red>Wprowadź klucz produktu, aby przejść dalej.</FONT>"; //add by joyce.min on 2007-8-29
var xmsgRegErrorProkey1=     "<FONT color=red>Klucz produktu jest zbyt krótki.</FONT>"; //add by joyce.min on 2007-9-7
var xmsgRegErrorHdr=		"Błąd rejestracji-aktywacji";
var xmsgRegErrorSystem=		"Tymczasowy problem w systemie wywołał błąd w rejestracji. Proszę kliknąć jeden z poniższych odnośników."
var xmsgRegErrorPrevReg=	"Ten numer seryjny jest już zarejestrowany.";
var xmsgRegErrorMaxAuth=	"Przekroczono dopuszczalną liczbę aktywacji tego produktu.";
var xmsgRegErrorMaxAuth2=	"Przekroczono dopuszczalną liczbę autoryzacji tego produktu.";
var xmsgRegErrorInvalidOld=	"Numer seryjny podany dla poprzedniego produktu nie jest poprawny. Proszę sprawdzić czy poprzedni numer seryjny wyświetlany powyżej jest poprawny. Następnie kliknąć jeden z poniższych odnośników.";
var xmsgRegErrorData=		"Wystąpił problem w podanych informacjach rejestracyjnych. Wybierz opcję Spróbuj ponownie aby przejrzeć i poprawić wprowadzone informacje, użyj innej metody rejestracji lub skontaktuj się z firmą Autodesk w celu kontynuacji.";
var xmsgRegErrorNetwork=	"Rejestrowany produkt jest produktem autoryzowanym sieciowo i musi być w ten sposób instalowany. Należy odinstalować program i wybrać \"Sieć\" jako typ instalacji.<p>Instalacja i autoryzacja oprogramowania w wersji sieciowej opisana jest w podręczniku instalacji.";
var xmsgRegNoResponse=		"Tymczasowy problem w systemie wywołał błąd w rejestracji bezpośredniej. Proszę kliknąć jeden z poniższych odnośników. Tymczasowy problem w systemie wywołał błąd w Twojej rejestracji on-line. Proszę wybrać opcję poniżej, a następnie kliknij Dalej.";
var xmsgRegErrorAuthEntry=	"Wystąpił problem z podanym kodem aktywacji. Proszę kliknąć jeden z poniższych odnośników.";
var xmsgRegErrorAuthPermission = "Aby aktywować ten produkt firmy Autodesk, musisz mieć uprawnienia administratora lub uprawnienia użytkownika zaawansowanego, nadane przez administratora systemu. Skonsultuj się ze swoim administratorem systemu aby uzyskać więcej informacji na temat uprawnień administratora i użytkownika zaawansowanego.";							
var xmsgRegErrorAuth=		"Wystąpił problem z kodem aktywacji. Proszę kliknąć jeden z poniższych odnośników.";
var xmsgRegErrorFlex=		"Wystąpił problem z licencją. Proszę kliknąć jeden z poniższych odnośników.";
var xmsgRegConnError=		"Błąd połączenia";
var xmsgRegConnErrorTxt=	"Wystąpił problem z połączeniem z internetem. Proszę kliknąć jeden z poniższych odnośników.";
var xmsgRegPurchError3=		"Skorzystaj z innej metody zakupu";
//modified as LFSpec_SCV commend by joyce.min
var xmsgRegPurchError5=		 "Dziękujemy za zakup oprogramowania firmy Autodesk.<p>Połączenie wymagane do ukończenia tego procesu nie jest obecnie dostępne, prawdopodobnie ze względu na ustawienia systemowe.<p>Kliknij dowolne łącze poniżej, aby otworzyć przeglądarkę. Być może pozwoli to na nawiązanie połączenia.<p>";

var xmsgAuthResellerMsg1=	"Zakup od lokalnego sprzedawcy. Aby dokonać zakupu, należy skontaktować się z lokalnym sprzedawcą.";

var xmsgLicSaveErrInfo=		"Wystąpił błąd podczas zapisywania pliku licencji. Proszę kliknąć jeden z poniższych odnośników.";

var xmsgOnlineStoreMsg1=	"Zakup w sklepie internetowym Autodesk Online. Jeśli nie możesz znaleźć w sklepie produktu, którego poszukujesz, skontaktuj się z Autoryzowanym Sprzedawcą.";
var xmsgOnlineStoreMsg2=    "Sklep internetowy";
var xmsgAuthResellerMsg2=	"Autoryzowani sprzedawcy";
var xmsgLocateLicenseMsg1=	"Lokalizacja pliku licencji";
var xmsgLocateLicenseMsg2=	"Podaj ścieżkę do pliku licencji (lub użyj Przeglądaj by go zlokalizować), a następnie kliknij Dalej by kontynuować.";
var xmsgLocateLicenseMsg3=	"Istniejący plik licencji:";
var xmsgUserContactMsg=		"Należy podać przynajmniej jeden z poniższych:";
var xmsgFailureMsg=		    "Nie można przetworzyć tego zgłoszenia aktywacji w trybie online.";

/////////////////////////////////////////////
// Default Ereg returned error messages
/////////////////////////////////////////////
var xmsgDefaultEregReturnedErrMsg=  "Podczas przetwarzania zgłoszenia aktywacji wystąpił błąd (%1), który uniemożliwia automatyczną aktywację produktu.";
var xmsgRegErrorOnline=		"Kliknij poniższe łącze \„Użyj innej metody\”, aby wypełnić niezbędne formularze i wysłać zgłoszenie do najbliższego centrum obsługi klienta Autodesk. W ciągu 2 dni roboczych otrzymasz odpowiedź od przedstawiciela działu obsługi klienta.";
var xmsgAnotherFormSubmitMethod=    "Użyj innej metody";

/////////////////////////////////////////////
// Timeout message
/////////////////////////////////////////////
var xmsgTimeoutMsg1=    "Upłynął limit czasu zgłoszenia aktywacji w trybie online."
var xmsgTimeoutMsg2=    "Kliknij łącze \„Spróbuj ponownie”\, aby ponownie wysłać zgłoszenie w trybie online. Jeśli problem wystąpi ponownie, możesz kliknąć łącze \„Użyj innej metody”\, aby wysłać zgłoszenie pocztą e-mail, faksem lub inną metodą.";

/////////////////////////////////////////////
// Single User Network RESOURCES HERE:
/////////////////////////////////////////////
var xmsgRegSunData1=		"Zapisano dane rejestracji";
var xmsgRegSunData2=		"Dane rejestracji wymagane do identyfikacji klienta zapisano w ";
var xmsgRegSunData3=		"Podany stary numer seryjny nie jest poprawny do rejestracji uaktualnienia. Skontaktuj się z administratorem.";
var xmsgRegSunData4=		"Oprogramowanie to musi być ponownie zainstalowane z poprawnym starym numerem seryjnym.";
var xmsgRegSunData5=		"Wielokrotny obraz jednostanowiskowy";
var xmsgRegSunData6=		"Aby zakończyć wielokrotny obraz jednostanowiskowy, niezbędne są informacje rejestracyjne. Na kolejnych stronach:";
var xmsgRegSunData7=		"Zebrane zostaną wymagane informacje.";
var xmsgRegSunData8=		"Umożliwia wprowadzenie starego numeru seryjnego jeśli jest wymagany dla uaktualnienia.";
var xmsgRegSunData9=		"Przechowasz te informacje na serwerze dla instalacji wszystkich klientów.";
var xmsgRegSunData10=		"Oprogramowanie zostanie zarejestrowane przy użyciu tych informacji. Naciśnij Dalej aby kontynuować.";

/////////////////////////////////////////////
// Voluntary RESOURCES HERE:
/////////////////////////////////////////////
var xmsgRegVol1=	"Rejestracja produktu";
var xmsgRegVol2=	"Wybierz dowolną opcję i kliknij przycisk Dalej:";
var xmsgRegVol3=	"Zarejestruj teraz — wybierz tę opcję, aby rozpocząć rejestrację w trybie online";
var xmsgRegVol4=	"Zarejestruj później - wybierz tą opcję aby uruchomić program teraz";
var xmsgRegVol5=	"Nie wyświetlaj ponownie.";
var xmsgRegVol6=	"(Jeśli chcesz zarejestrować się później, możesz wybrać opcję rejestracji po wybraniu pozycji menu Pomoc|O programie)";

/////////////////////////////////////////////
// Japan RESOURCES HERE:
/////////////////////////////////////////////
var xmsgCustIDMainTitle=	"Identyfikacja użytkownika";
var xmsgKatakana=		    "Nazwa firmy (Zenkaku Kana):";
var xmsgDepartment=		    "Dział:";
var xmsgDepartment2=		"Nazwa wydziału:";

/////////////////////////////////////////////
// Autodesk Contact RESOURCES HERE:
/////////////////////////////////////////////
var xmsgFormWebHdr=	"W sieci Internet:";
var xmsgFormWebDataMsg1= "Kod aktywacji można również uzyskać, odwiedzając:<br>";
var xmsgFormEmailHdr=	"Email:";
var xmsgFormEmailData=	"";
var xmsgFormEmailDataBlock= "";
var xmsgFormEmailXMLData=	"";
var xmsgFormEmailXMLDataBlock= "";
var xmsgFormFaxHdr=		"Faks:";
var xmsgFormFaxHdrLocal=	"Faks do lokalnego biura:";
var xmsgFormFaxHdrReg=	"Rejestracja poprzez faks:";
var xmsgFormFaxData=	"";
var xmsgFormFaxDataRegister=	"";
var xmsgFormCallHdr=	"Telefon:";
var xmsgFormCallData=	"";
var xmsgFormMailHdr=	"Poczta tradycyjna:";
var xmsgFormMailHdrLocal=	"List do lokalnego biura:";
var xmsgFormMailHdrReg=	"Rejestracja pocztowa:";
var xmsgFormMailData=	"";
var xmsgFormMailDataRegister=   "";
var xmsgFormPurchHdr=	"Zakup oprogramowania";
var xmsgFormInternetMsg=    "Aby uzyskać kod aktywacji za pomocą przeglądarki internetowej, kliknij to łącze."
var xmsgFormEmailMsg=       "Korespondencję i zgłoszenia aktywacji należy wysyłać na adres e-mail:"

/////////////////////////////////////////////
// Privacy Statement RESOURCES HERE:
/////////////////////////////////////////////

var JPprivacystatement = "Podane informacje zostaną użyte przez firmę Autodesk do zarejestrowania i/lub wydania kodu aktywacji. Rejestracja potwierdza udzielenie firmie Autodesk zgody na udostępnianie Twoich danych swoim Autoryzowanym Partnerom Handlowym na potrzeby zarządzania licencjami produktów i weryfikacji uprawnień. Jeśli nie chcesz, aby firma Autodesk udostępniała te informacje swoim Autoryzowanym Partnerom Handlowym w wyżej wymienionych celach, prosimy o kontakt na adres <a href=mailto:information@autodesk.jp>information@autodesk.jp</a>. Aby poprawić lub zaktualizować dane rejestracyjne, kliknij <a %1>TUTAJ</a> w celu skontaktowania się z firmą Autodesk lub jej lokalnym biurem.";
			
var privacystatement = "Podane informacje zostaną użyte przez firmę Autodesk do zarejestrowania i/lub wydania kodu aktywacji, do przesyłania informacji o produktach i usługach oraz do zapewnienia dodatkowych korzyści wynikających z rejestracji jako autoryzowany użytkownik produktów firmy Autodesk. Autodesk nie sprzeda, ani w żaden inny sposób nie udostępni tych informacji nikomu spoza firmy Autodesk lub jej autoryzowanych partnerów handlowych. Aby poprawić lub zaktualizować wcześniej podane informacje rejestracyjne, proszę kliknąć <a %1>TUTAJ</a>, aby skontaktować się z firmą Autodesk lub jej lokalnym biurem.";
				
			
/////////////////////////////////////////////
// Privacy Policy
/////////////////////////////////////////////
var xmsgPrivacyPolicy="Polityka prywatności";

/////////////////////////////////////////////
// Copyright
/////////////////////////////////////////////
var xmsgCopyright="(c) Copyright 2009 Autodesk, Inc. Wszelkie prawa zastrzeżone."; //modify by joyce.min on 2007-8-14

/////////////////////////////////////////////
// Rebranding Message
/////////////////////////////////////////////
var xmsgRebranding="W większości przypadków nowy numer seryjny zostanie wyświetlony dopiero po zamknięciu programu i uruchomieniu go ponownie z prawami administratora.";
var xmsgRebranding2="Informacje dotyczące uruchamiania programów z prawami administratora można znaleźć w dokumentacji systemu operacyjnego.";
/////////////////////////////////////////////
//  Note to Localization :
//
//	"InsertRegInfo" appears in RTUserInfo.html.  The full sentence in English is
//
//	"Fields marked in <FONT color=red>red</FONT> and with an asterisk (<FONT 
//	color=red>*</FONT>) are required to process your registration. Complete the form 
//	and click Next."
//
/////////////////////////////////////////////
var xmsgRegInfoMsg1= "Wypełnienie pól oznaczonych <FONT color=red>*</FONT> jest niezbędne.";
var xmsgRegInfoMsg2= "Informacje podane na tej stronie są zapisywane z licencją. Są używane do ponownej aktywacji i uaktualnień produktu. Proszę upewnić się, czy podane tutaj informacje są poprawne, aby zapobiec opóźnieniu w używaniu tego produktu.";

var xmsgLicLocationText1 = "Zapisz plik licencji dla <b>%1</b> do:";

// Set Registration Info Header
var InsertRegInfo =     "<p><b>"+xmsgRegInfo+"</b></p>" +
			  "<p>" + xmsgRegInfoMsg1 + "</p>";


//=======================================================================
// Application Usage Information
//=======================================================================
var xmsgAppUsage=	"Pytania:";

var xmsgAppUsageQ1=	"Aby pomóc firmie Autodesk lepiej poznać specyficzne potrzeby twojej branży, odpowiedz na następujące pytanie.";
var xmsgAppUsageQ2=	"Do jakiej kategorii można zaliczyć podstawowy obszar Twojej działalności?";

var xmsgAppUsageOption51=	"Projektowanie elementów dla motoryzacji, lotnictwa i astronautyki ";
var xmsgAppUsageOption52=	"Architektura ";
var xmsgAppUsageOption53=	"Zarządzanie budynkami i obiektami ";
var xmsgAppUsageOption54=	"Budownictwo: Usługowe ";
var xmsgAppUsageOption55=	"Budownictwo: Mieszkaniowe ";
var xmsgAppUsageOption56=	"Produkcja sprzętu budowlanego ";
var xmsgAppUsageOption57=	"Inżynieria wodno-lądowa / Planowanie przestrzenne ";
var xmsgAppUsageOption58=	"Projektowanie sprzętu komputerowego, medycznego, biurowego ";
var xmsgAppUsageOption67=	"Projektowanie produktów konsumpcyjnych ";
var xmsgAppUsageOption59=	"Posiadanie budynku firmowego ";
var xmsgAppUsageOption92=	"Inżynieria wojskowa ";
var xmsgAppUsageOption93=	"Projektowanie elektrycznych elementów sterujących ";
var xmsgAppUsageOption94=	"Inżynieria systemów elektrycznych ";
var xmsgAppUsageOption72=	"Inżynieria środowiska ";
var xmsgAppUsageOption95=	"Prefabrykowane wyroby metalowe ";
var xmsgAppUsageOption96=	"Projektowanie wnętrz ";
var xmsgAppUsageOption97=	"Projektowanie maszyn ";
var xmsgAppUsageOption98=	"Zaopatrzenie produkcji / sprzedaż / marketing ";
var xmsgAppUsageOption40=	"Mapy i projektowanie geoprzestrzenne ";
var xmsgAppUsageOption41=	"Inżynieria systemów mechanicznych (HVAC i rury) ";
var xmsgAppUsageOption42=	"Hydraulika i/lub ochrona przeciwpożarowa ";
var xmsgAppUsageOption43=	"Projekty procesowe i zespołów napędowych ";
var xmsgAppUsageOption44=	"Nieruchomości ";
var xmsgAppUsageOption45=	"Inżynieria budowlana ";
var xmsgAppUsageOption87=	"Telekomunikacja ";
var xmsgAppUsageOption46=	"Obrabianie i wytłaczanie / warsztat mechaniczny ";
var xmsgAppUsageOption47=	"Projektowanie systemów transportu ";
var xmsgAppUsageOption48=	"Elektryczność, ropa i gazownictwo ";
var xmsgAppUsageOption49=	"Wodociągi i kanalizacja ";
var xmsgAppUsageOption99=	"Inny ";

var xmsgWrongCountryCodeMsg=	"Błąd: Wprowadzono nieznany kod kraju!";

/////////////////////////////////////////////
// Version RESOURCES HERE:
/////////////////////////////////////////////
var xmsgVersion = "Wersja:"

/////////////////////////////////////////////
// Access RTFax or RTMail through RTEmail
/////////////////////////////////////////////
var xmsgAccessFaxMsg=		"Przekażę zgłoszenie faksem lub telefonicznie"; //modify by joyce.min on 2007-10-18 as Licensing_Framework Spec_Frozen.doc recommend 
var xmsgAccessMailMsg=		"Rejestracja za pomocą poczty elektronicznej.";
var xmsgAccessHereMsg=		"tutaj.";

/////////////////////////////////////////////
// Receive code by
/////////////////////////////////////////////
var xmsgReceiveCodeMsg=     "Chcę uzyskać kod przez:";
var xmsgReceiveCodeMsg1=     "Otrzymam plik aktywacji pocztą e-mail"; //add by joyce.min on 2007-8-20
/////////////////////////////////////////////
// Messages for Ease of reauth or multi-seat client registration
/////////////////////////////////////////////
var xmsgNoDialogHdrMsg=		"Proszę poczekać chwilę, licencja jest w trakcie <br>weryfikacji";
/////////////////////////////////////////////
//Resource for RTProductInfo
/////////////////////////////////////////////
var xmsgRTProductInfoTitle=      "Informacje o produkcie"; //add by joyce.min on 2007-8-14
var xmsgRTProductInfoMsg1=        "Wymagane są wszystkie pola."; //add by joyce.min on 2007-8-14
/////////////////////////////////////////////
//Error for RTProductInfo
/////////////////////////////////////////////
//var xmsgsernumError=        "Enter a serial number to proceed."; //add by joyce.min on 2007-8-17
//var xmsgprokeyError=        "Enter a product key to proceed." ; //add by joyce.min on 2007-8-17
/////////////////////////////////////////////
// Resource for NSA_RTBegin.html
/////////////////////////////////////////////
var xmsgNSARTBeginTitle=	"Otrzymywanie licencji sieciowej";
var xmsgNSARTBeginMsg1=		"Uzyskaj plik aktywacji licencji sieciowej przez:";
var xmsgNSARTBeginMsg2=		"Połączenie bezpośrednie (przez Internet)";
var xmsgNSARTBeginMsg3=		"Wyślij zgłoszenie pocztą e-mail, faksem lub telefonicznie";
var xmsgNSARTBeginNoInternet=	"";

/////////////////////////////////////////////
// Edit server and seat information
/////////////////////////////////////////////
var xmsgEditServerHdrMsg1=	"Informacje o serwerze";
var xmsgEditServerHdrMsg2=	"Model serwera licencji*";
var xmsgEditServerMsg1=		"Podaj informacje o serwerze licencji. Kliknij przycisk Sprawdź, aby wypełnić pole ID serwera.<p>";
var xmsgEditServerMsg2=		"Rozpocznij z danymi serwera hosta z istniejącego pliku(ów) licencji.";
var xmsgEditServerRemove=	"Usuń";
var xmsgEditServerHostName=	"Nazwa serwera hosta*";
var xmsgEditServerHostID=	"ID hosta*";
var xmsgEditServerSeat=		"Stanowiska*";
var xmsgEditServerSingle=	"Serwer samodzielny";
var xmsgEditServerDistributed=	"Serwer rozproszony";
var xmsgEditServerRedundant=	"Serwer nadmiarowy";
var xmsgEditServerDots=		"...";
var xmsgEditServerLookup=	"Sprawdź";
var xmsgEditServerAddServer=	"Dodaj";
var xmsgEditServerRemoveServer=	"Usuń";
var xmsgEditServerTotal=	"Razem:";
var xmsgEditServerExceedMaxServer=	"Uwaga: Możesz licencjonować maksymalnie 20 rozproszonych serwerów w danej chwili. Jeżeli potrzebujesz więcej niż 20 serwerów, skontaktuj się z firmą Autodesk.";
var xmsgEditServerSeatError=	"Stanowiska określane są tylko przez wartość numeryczną.";

var xmsgConfirmServerMsg=	"Sprawdź poniższe informacje. Kliknij Dalej by kontynuować lub Wstecz by wprowadzić zmiany.";
var xmsgConfirmServerMsg2=	"Gdy klikniesz Dalej, te informacje zostaną wysłane do firmy Autodesk przez Internet.";
var xmsgConfirmServerHdr2=	"Model serwera licencji:";
var xmsgConfirmServerHostName=	"Nazwa serwera hosta";
var xmsgConfirmServerHostID=	"ID hosta";
var xmsgConfirmServerSeat=		"Stanowiska";
var xmsgConfirmServerTotal=		"Całkowita liczba stanowisk:";

var xmsgLicErrorHdr=			"Błąd licencjonowania"; 
var xmsgLicErrorInvalidSN=		"Podany numer seryjny jest nieprawidłowy. Sprawdź, czy wyświetlony powyżej numer jest poprawny. Kliknij jeden z poniższych odnośników.";
var xmsgLicReEnterSN=			"Podaj ponownie numer seryjny i spróbuj jeszcze raz.";

var xmsgLic113Msg2=				"Całkowita liczba stanowisk przypisanych do serwerów rozproszonych przekracza tą liczbę.";
var xmsgLic113ModifySeats=		"Zmodyfikuj dystrybucję stanowisk";

var xmsgSaveLicenseHdr=			"Otrzymano licencję(e)";
var xmsgSaveLicenseMsg1=		"Firma Autodesk przesłała już żądane licencje. Teraz musisz zapisać je do pliku licencji.<p> <b>Zapisz licencję(e) w pliku(ach) licencji</b><p><LI><b>Zalecanym położeniem</b> dla pliku(ów) licencji jest katalog \"License\", w którym zainstalowano Menedżera licencji sieciowej Autodesk na serwerze.&nbsp;&nbsp;";
var xmsgSaveLicenseMsg6=		"<LI>Jeżeli posiadasz <b>istniejący plik licencji</b>, <b>wstaw</b> do niego nową licencję.<br>Gdy klikniesz Dalej, system automatycznie wstawi informacje licencji w odpowiednie miejsce istniejącego pliku.</LI>";
var xmsgSaveLicenseMsg2=		"Jeżeli podany powyżej plik jest istniejącym plikiem licencji:";
var xmsgSaveLicenseMsg3=		"Wstaw informację o nowej licencji do niego.";
var xmsgSaveLicenseMsg4=		"Nadpisz istniejący plik licencji.";
var xmsgSaveLicenseMsg5=		"Proszę skorygować następujące błędy:";

var xmsgSaveErrorFileNameTooLong=  "BŁĄD: Wprowadzona nazwa pliku jest zbyt długa.<br>" +
								"Zmień nazwę pliku i kontynuuj.";
var xmsgSaveErrorNoPermission=	"BŁĄD: Nie masz uprawnień do zapisywania pliku w podanej lokalizacji.<br>Możesz zapisać ten plik w lokalizacji tymczasowej, uzyskać odpowiednie uprawnienia i później przenieść plik.";
var xmsgSaveErrorNoDiskSpace=	"BŁĄD: Nie masz wystarczająco dużo wolnej przestrzeni do zapisania tego pliku w podanej lokalizacji.<BR>Możesz zapisać plik w lokalizacji tymczasowej, udostępnić przestrzeń, a następnie przenieść plik.";
var xmsgSaveErrorInvalidFile=	"BŁĄD: Nowa licencja nie może być dołączona do wskazanego pliku bez utraty danych. Wskazany plik może być przeznaczony dla innego komputera lub innego modelu serwera.<BR>Możesz zapisać nowy plik licencji pod inną nazwą lub w innej lokalizacji i dołączyć go do tego pliku ręcznie.";															
var xmsgSaveErrorPathNotExit=	"BŁĄD: Określona ścieżka nie istnieje.<BR>Kliknij przycisk Przeglądaj, w celu zlokalizowania lub utworzenia ścieżki.";
var xmsgSaveErrorPathBlank=		"BŁĄD: Należy określić poprawną ścieżkę dostępu i nazwę pliku licencji. Podaj ścieżkę i nazwę pliku w polu poniżej lub przeglądaj w celu zlokalizowania odpowiedniego pliku.";

var xmsgLicAuthConfirmHdr1=		"Aktywację licencji zakończono pomyślnie!";
var xmsgLicAuthConfirmHdr2=		"Informacja o licencji serwera hosta";
var xmsgLicAuthConfirmMsg1=		"Dziękujemy za zarejestrowanie produktu. Możesz teraz wydrukować te informacje.";
var xmsgLicAuthConfirmDate=		"Data:";

var xmsgLicPathMsg1=			"Zapisane zostały następujące pliki licencji:";
var xmsgLicPathMsg2=			"Twoje pliki licencji zostały zapisane w:";

var xmsgOtherMethodMsg1NSA=		"Skorzystaj z innej metody uzyskania autoryzacji licencji.";
var xmsgOtherMethodMsg1=		"Skorzystaj z innej metody.";

var xmsgContactAutodeskMsg1=	"Użyj jednej z następujących metod, aby skontaktować się z firmą Autodesk.";
								
/////////////////////////////////////////////
// Email Options
/////////////////////////////////////////////
var xmsgEmailOptionNSATitle=	"Uzyskaj plik licencji przez e-mail";
var xmsgEmailOptionTitle=		"Zarejestruj przez e-mail";
var xmsgEmailOptionNSAMsg=		"Twoje dane rejestracyjne i dane dotyczące serwera licencji zostały automatycznie zapisane w pliku. Należy go przesłać pocztą elektroniczną do centrum automatycznej rejestracji firmy Autodesk.<p>Po pomyślnym odebraniu pliku zostanie wysłana automatyczna odpowiedź, autoryzowany plik licencji i instrukcje dalszego postępowania.";
var xmsgEmailOptionMsg=			"Twoje dane rejestracyjne zostały automatycznie zapisane w pliku. Należy go przesłać pocztą elektroniczną do centrum automatycznej rejestracji firmy Autodesk.<p>Po pomyślnym odebraniu pliku zostanie wysłana automatyczna odpowiedź i instrukcje dalszego postępowania.";
var xmsgEmailOptionMsg2=		"Jeżeli domyślny system poczty elektronicznej może teraz wysłać e-mail przez Internet, zaznacz Wyślij teraz plik, a potem Dalej. Plik zostanie wysłany automatycznie.<p>Jeżeli teraz nie możesz wysłać poczty, zaznacz Wyślij później plik. Instrukcje samodzielnego wysłania pliku zostaną podane później.";
var xmsgEmailOptionInfo1=		"Wyślij teraz plik.";
var xmsgEmailOptionInfo2=		"Wyślij później plik, samodzielnie.";
var xmsgEmailOptionInfo3=		"Wyślij kopię na podany adres e-mail.";

/////////////////////////////////////////////
// Email Error
/////////////////////////////////////////////
var xmsgEmailErrorHdr=			"Nie można utworzyć emaila";
var xmsgEmailErrorMsg1=			"Aby zakończyć rejestrację pocztą elektroniczną, dołącz poniższy plik do emaila:";
var xmsgEmailErrorMsg2=			"Wyślij email do %1.";
var xmsgEmailErrorMsg3=			"Plik znajduje się w poniższym położeniu:";

/////////////////////////////////////////////
// Local HERE customer information URLs
/////////////////////////////////////////////
var xmsgLocalHERETitle=			"Zmień informacje o użytkowniku";
var xmsgLocalHEREInfo=			"Aby zmienić własne informacje o użytkowniku, skontaktuj się z Autoryzowanym Sprzedawcą Autodesk lub skorzystaj z poniższego odnośnika, odpowiedniego dla twojego kraju lub regionu.";
var xmsgLocalHEREUS=			"Ameryki";
var xmsgLocalHEREEMEA=			"Europa, Środkowy Wschód, Afryka";
var xmsgLocalHEREAPAC=			"Azja/Pacyfik";

/////////////////////////////////////////////
// Help
/////////////////////////////////////////////
var xmsgHelpTitle=				"Pomoc";
var xmsgHelpUpgradeMsg=			"Jeżeli rejestrujesz lub aktywujesz uaktualnienie z poprzedniej wersji, musisz odznaczyć to pole i po monicie podać numer seryjny wersji, z której uaktualniasz.";
var xmsgHelpUpgradeRequiredTitle=	"Podaj numer seryjny poprzedniego produktu (wymagane do uaktualnienia)";
var xmsgHelpUpgradeRequiredMsg=	"To jest numer seryjny z poprzedniej wersji oprogramowania. Numer seryjny można znaleźć albo w programie w oknie dialogowym Pomoc > Informacje, albo na opakowaniu poprzedniego produktu.";

//	Fax or email error message
var xmsgNotEnterErrorMsg=		"Nie podano następującej informacji: %1. Wprowadź tę informację, aby otrzymać aktywację tą metodą.";								

//  Help for serial number
var xmsgHelpSerialNumberTitle=  "Numer seryjny/ID grupy"; ////modify by joyce.min on 2007-8-16
var xmsgHelpSerialNumberMsg=    "Numer seryjny znajduje się na opakowaniu produktu lub w wiadomości e-mail zawierającej informacje dotyczące uaktualnienia i licencjonowania firmy Autodesk."; // ECO19

//  Help for ProductInfo serial number & Product Key //modify by joyce.min on 2007-8-16
var xmsgHelpProductKeyTitle=   "Klucz produktu";
var xmsgHelpProductKeyMsg=    "Klucz produktu znajduje się obok numeru seryjnego na opakowaniu produktu lub w wiadomości e-mail zawierającej informacje na temat uaktualnień i licencjonowania produktów Autodesk."; // ECO19

/////////////////////////////////////////////
// The following strings are added back for backward competibility reason
/////////////////////////////////////////////
var xmsgRT0015TempSysErr=				"Błąd połączenia (0.15)";
var xmsgRT010203071213CannotCompErrA=	"Błąd rejestracji (1.2.3.7.12.13)";
var xmsgRT09AlreadyReg=					"Już zarejestrowany (9)";
var xmsgRT10ExceededAuths=				"Przekroczono uprawnienia (10)";
var xmsgRT12StolenSN=					"Ukradziony numer seryjny (12)";
var xmsgRT18OldSNInvalid=				"Niepoprawny poprzedni numer seryjny (18)";
var xmsgRT20DataError=					"Błąd danych (20)";
var xmsgRT21CustIDTelErr=				"Błąd ID/Tel klienta (21)";
var xmsgRT22NetworkInstallation=		"Błąd instalacji sieciowej (22)";
var xmsgRT900SystemNotResponding=		"System nie odpowiada (900)";
var xmsgRTCustID=						"Identyfikator klienta";
var xmsgRTCustIDConfirm=				"Potwierdzenie identyfikacji";
var xmsgRTNewSerialNumber=				"Informacje o nowym numerze seryjnym";
var xmsgRTNoNewSN=						"Błąd transakcji zakupu";
var xmsgRTPurchAuthFailed=				"Błąd aktywacji";
var xmsgRTPurchConfirmOther=			"Potwierdzenie zakupu";
var xmsgRTPurchConfirmPerm=				"Potwierdzenie zakupu - zarejestrowany i aktywowany";
var xmsgRTPurchConfirmReg=				"Potwierdzenie zakupu - zarejestrowany ale nie aktywowany";
var xmsgRTPurchConfirmRegVol=			"Potwierdzenie zakupu - zarejestrowany";
var xmsgRTPurchConfirmRent=				"Potwierdzenie zakupu - zarejestrowany i z aktywowanym wypożyczeniem";
var xmsgRTPurchConfirmUnReg=			"Potwierdzenie zakupu - nie zarejestrowany lub aktywowany";
var xmsgRTPurchConnectionFailed=		"Połączenie zakupu nie powiodło się";
var xmsgRTPurchaseError=				"Błąd zakupu";
var xmsgRTSNMismatch=					"Błąd transakcji zakupu - niezgodność numeru seryjnego";
var xmsgRTSUNOldSNInvalid=				"Niepoprawny poprzedni numer seryjny - SUN";

var szRTEmail =         "RTEmail.html";

var xmsgExit=			"Zakończ";

var xmsgCustIDMainTitle=	"Identyfikacja użytkownika";
var xmsgCustIDTitle1=		"ID użytkownika:";
var xmsgCustIDText2=		"Podaj poniżej swój identyfikator użytkownika i numer telefonu. Jeśli nie posiadasz identyfikatora użytkownika, pozostaw oba pola puste.<p> ";
var xmsgCustIDText3=		"Uwaga: Aby ponownie aktywować produkt, musisz wpisać swój identyfikator klienta.";
var xmsgCustIDText3NSA=		"Uwaga: Aby ponownie autoryzować produkt, musisz wpisać swój identyfikator klienta.";
var xmsgCustIDTitle2=		"Numer telefonu:";
var xmsgCustIDTelEx4=		"(przykład: 03-111-1234)";
var xmsgRegCustIDTel=		"Podany identyfikator użytkownika i numer telefonu nie pasują do danych w naszej bazie. Proszę kliknąć jeden z poniższych odnośników.";

/////////////////////////////////////////////
//  Note to Localization :
//
//	"xmsgRT113SeatMsg1" appears in NSA_RT113TooManySeats.html.  The full sentence in English is
//
//	"Our records indicate that you have [Max allowed seats] valid [product name] seats available." 
/////////////////////////////////////////////
var xmsgRT113SeatMsg1=	"W naszej bazie danych oznaczono, że posiadasz %1 ważnych %2 dostępnych stanowisk.<br>";

/////////////////////////////////////////////
// Error 12
/////////////////////////////////////////////
var xmsgErr12Hdr=				"Podany numer seryjny jest niepoprawny";
var xmsgErr12APAC=				"<p>To jest niepoprawny numer seryjny i nie można go aktywować. Proszę skontaktować się z nami na adres <a href=mailto:apacpl@listproc.autodesk.com target=\"_blank\">apacpl@listproc.autodesk.com</a></p>";
var xmsgErr12EMEA=				"<p>Szanowna Pani/Szanowny Panie</p><p>Dziękujemy za chęć zarejestrowania programu Autodesk&#0174; lub Discreet&#0153; w firmie Autodesk.</p><p>Niestety, z naszych danych wynika, że podany przez Panią/Pana numer seryjny programu Autodesk&#0174; lub Discreet&#0153; nie jest prawidłowym numerem seryjnym lub jest powszechnie znanym numerem seryjnym pirackiej kopii programu, co oznacza, że używa Pani/Pan nieautoryzowanej kopii programu Autodesk&#0174; lub Discreet&#0153;.</p><p>Licencje na produkty oprogramowania Autodesk&#0174; można uzyskać od autoryzowanych sprzedawców Autodesk. Listę autoryzowanych sprzedawców Autodesk i adres przedstawicielstwa Autodesk w danym kraju można znaleźć w witrynie <a href=\"http://www.autodesk.com\" target=\"_blank\">www.autodesk.com</a>. Korzystanie z legalnego oprogramowania jest jedynym sposobem, aby czerpać z niego maksymalne korzyści i uniknąć potencjalnych sankcji cywilnych i karnych w przypadku przyłapania na nielegalnym korzystaniu i/lub reprodukowaniu oprogramowania.</p><p>licencje na produkty oprogramowania Discreet&#0153; od autoryzowanych sprzedawców Discreet. Listę autoryzowanych sprzedawców Discreet i adres przedstawicielstwa Discreet w danym kraju można znaleźć w witrynie <a href=\"http://www.discreet.com\" target=\"_blank\">www.discreet.com</a>. Korzystanie z legalnego oprogramowania jest jedynym sposobem, aby czerpać z niego maksymalne korzyści i uniknąć potencjalnych sankcji cywilnych i karnych w przypadku ujawnienia faktu nielegalnego korzystania i/lub reprodukowania oprogramowania.</p><p>Uprzejmie prosimy o bezzwłoczne zaprzestanie korzystania z nieautoryzowanego oprogramowania, które Pani/Pan próbowała/próbował u nas zarejestrować, usunięcie wszystkich jego kopii przechowywanych na jakimkolwiek komputerze oraz zniszczenie wszystkich nośników zawierających ten program. Chociaż ufamy, że spełni Pani/Pan naszą prośbę dobrowolnie, to zastrzegamy sobie prawo, aby w odniesieniu do tej sprawy przekazać Pani/Pana dane organizacji Business Software Alliance (\"BSA\").</p><p>Jeśli ma Pani/Pan jakiekolwiek inne pytania lub uważa, że ta wiadomość została wysłana omyłkowo, prosimy o kontakt pod adresem: <a href=mailto:emea.register@activation.autodesk.com target=\"_blank\">Authcodes.neu@autodesk.com</a></p><p>Jeśli chce Pani/Pan udzielić informacji na temat korzystania lub sprzedaży nielegalnego oprogramowania, prosimy skontaktować się z naszym lokalnym przedstawicielstwem lub organizacją BSA, odwiedzając witrynę <a href=\"http://www.BSA.org\" target=\"_blank\">www.BSA.org</a></p><p>Dziękujemy</p>";
var xmsgErr12US=				"<p>Szanowna Pani/Szanowny Panie</p><p>Próbowała/Próbował Pani/Pan ostatnio zarejestrować swój program w firmie Autodesk lub Discreet.</p><p>Niestety, z naszych danych wynika, że podany przez Panią/Pana numer seryjny programu firmy Autodesk&#0174; lub Discreet&#0153; nie jest prawidłowym numerem seryjnym lub jest powszechnie znanym numerem seryjnym pirackiej kopii programu, co oznacza, że używa Pani/Pan nieautoryzowanej kopii programu Autodesk&#0174; lub Discreet&#0153;.</p><p>Licencje na produkty oprogramowania Autodesk&#0174; można uzyskać od autoryzowanych sprzedawców Autodesk. Listę autoryzowanych sprzedawców Autodesk i adres przedstawicielstwa Autodesk w danym kraju można znaleźć w witrynie <a href=\"http://www.autodesk.com\" target=\"_blank\">www.autodesk.com</a>. Korzystanie z legalnego oprogramowania jest jedynym sposobem, aby czerpać z niego maksymalne korzyści i uniknąć potencjalnych sankcji cywilnych i karnych w przypadku przyłapania na nielegalnym korzystaniu i/lub reprodukowaniu oprogramowania.</p><p>Użytkownicy programów Discreet&#0153; mogą nabyć licencje na produkty oprogramowania Discreet&#0153; od autoryzowanych sprzedawców Discreet. Listę autoryzowanych sprzedawców Discreet i adres przedstawicielstwa Discreet w danym kraju można znaleźć w witrynie <a href=\"http://www.discreet.com\" target=\"_blank\">www.discreet.com</a>. Korzystanie z legalnego oprogramowania jest jedynym sposobem, aby czerpać z niego maksymalne korzyści i uniknąć potencjalnych sankcji cywilnych i karnych w przypadku przyłapania na nielegalnym korzystaniu i/lub reprodukowaniu oprogramowania.</p><p>Musi Pani/Pan bezzwłocznie zaprzestać korzystania z nieautoryzowanego oprogramowania, które Pani/Pan próbowała/próbował u nas zarejestrować, usunąć wszystkie jego kopie przechowywane na jakimkolwiek komputerze oraz zniszczyć wszystkie nośniki zawierające ten program. Chociaż ufamy, że spełni Pani/Pan nasze żądania dobrowolnie, to zastrzegamy sobie prawo, aby w odniesieniu do tej sprawy przekazać Pani/Pana dane organizacji Business Software Alliance („BSA”).</p><p>Jeśli ma Pani/Pan jakiekolwiek inne pytania lub uważa, że ta wiadomość została wysłana omyłkowo, prosimy o kontakt pod adresem: <a href=mailto:ProductActivation@activation.autodesk.com target=\"_blank\">ProductActivation@activation.autodesk.com</a></p><p>Jeśli chce Pani/Pan udzielić informacji na temat korzystania lub sprzedaży nielegalnego oprogramowania, prosimy skontaktować się z naszym lokalnym przedstawicielstwem lub organizacją BSA, odwiedzając witrynę <a href=\"http://www.BSA.org\" target=\"_blank\">www.BSA.org</a></p><p>Dziękujemy</p>";






// SIG // Begin signature block
// SIG // MIIVVAYJKoZIhvcNAQcCoIIVRTCCFUECAQExCzAJBgUr
// SIG // DgMCGgUAMGcGCisGAQQBgjcCAQSgWTBXMDIGCisGAQQB
// SIG // gjcCAR4wJAIBAQQQEODJBs441BGiowAQS9NQkAIBAAIB
// SIG // AAIBAAIBAAIBADAhMAkGBSsOAwIaBQAEFEaePZvoCnQS
// SIG // YbX4HnfriFJHUg5GoIIRFjCCA3owggJioAMCAQICEDgl
// SIG // 1/r4Ya+e9JDnJrXWWtUwDQYJKoZIhvcNAQEFBQAwUzEL
// SIG // MAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJ
// SIG // bmMuMSswKQYDVQQDEyJWZXJpU2lnbiBUaW1lIFN0YW1w
// SIG // aW5nIFNlcnZpY2VzIENBMB4XDTA3MDYxNTAwMDAwMFoX
// SIG // DTEyMDYxNDIzNTk1OVowXDELMAkGA1UEBhMCVVMxFzAV
// SIG // BgNVBAoTDlZlcmlTaWduLCBJbmMuMTQwMgYDVQQDEytW
// SIG // ZXJpU2lnbiBUaW1lIFN0YW1waW5nIFNlcnZpY2VzIFNp
// SIG // Z25lciAtIEcyMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCB
// SIG // iQKBgQDEtfJSFbyIhmApFkpbL0uRa4eR8zVUWDXq0TZe
// SIG // Yk1SUTRxwntmHYnI3SrEagr2N9mYdJH2kq6wtXaW8alK
// SIG // Y0VHLmsLkk5LK4zuWEqL1AfkGiz4gqpY2c1C8y3Add6N
// SIG // q8eOHZpsTAiVHt7b72fhcsJJwp5gPOHivhajY3hpFHut
// SIG // LQIDAQABo4HEMIHBMDQGCCsGAQUFBwEBBCgwJjAkBggr
// SIG // BgEFBQcwAYYYaHR0cDovL29jc3AudmVyaXNpZ24uY29t
// SIG // MAwGA1UdEwEB/wQCMAAwMwYDVR0fBCwwKjAooCagJIYi
// SIG // aHR0cDovL2NybC52ZXJpc2lnbi5jb20vdHNzLWNhLmNy
// SIG // bDAWBgNVHSUBAf8EDDAKBggrBgEFBQcDCDAOBgNVHQ8B
// SIG // Af8EBAMCBsAwHgYDVR0RBBcwFaQTMBExDzANBgNVBAMT
// SIG // BlRTQTEtMjANBgkqhkiG9w0BAQUFAAOCAQEAUMVLyCSA
// SIG // 3+QNJMLeGrGhAqGmgi0MgxWBNwqCDiywWhdhtdgF/ojb
// SIG // 8ZGRs1YaQKbrkr44ObB1NnQ6mE/kN7qZicqVQh2wuceg
// SIG // jVfg+tVkBEI1TgHRM6IXyE2qJ8fy4YZMAjhNg3jG/FPg
// SIG // 6+AGh92klp5eDJjipb6/goXDYOHfrSjYx6VLZNrHG1u9
// SIG // rDkI1TgioTOLL4qa67wHIT9EQQkHtWUcJLxI00SA66HP
// SIG // yQK0FM9UxxajgFz5eT5dcn2IF54sQ6LKU859PfYqOrhP
// SIG // lAClbQqDXfleU/QYs1cPcMP79a2VoA4X3sQWgGDJDytu
// SIG // hgTx6/R4J9EFxe40W165STLyMzCCA8QwggMtoAMCAQIC
// SIG // EEe/GZXfjVJGQ/fbbUgNMaQwDQYJKoZIhvcNAQEFBQAw
// SIG // gYsxCzAJBgNVBAYTAlpBMRUwEwYDVQQIEwxXZXN0ZXJu
// SIG // IENhcGUxFDASBgNVBAcTC0R1cmJhbnZpbGxlMQ8wDQYD
// SIG // VQQKEwZUaGF3dGUxHTAbBgNVBAsTFFRoYXd0ZSBDZXJ0
// SIG // aWZpY2F0aW9uMR8wHQYDVQQDExZUaGF3dGUgVGltZXN0
// SIG // YW1waW5nIENBMB4XDTAzMTIwNDAwMDAwMFoXDTEzMTIw
// SIG // MzIzNTk1OVowUzELMAkGA1UEBhMCVVMxFzAVBgNVBAoT
// SIG // DlZlcmlTaWduLCBJbmMuMSswKQYDVQQDEyJWZXJpU2ln
// SIG // biBUaW1lIFN0YW1waW5nIFNlcnZpY2VzIENBMIIBIjAN
// SIG // BgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAqcqypMzN
// SIG // IK8KfYmsh3XwtE7x38EPv2dhvaNkHNq7+cozq4QwiVh+
// SIG // jNtr3TaeD7/R7Hjyd6Z+bzy/k68Numj0bJTKvVItq0g9
// SIG // 9bbVXV8bAp/6L2sepPejmqYayALhf0xS4w5g7EAcfrkN
// SIG // 3j/HtN+HvV96ajEuA5mBE6hHIM4xcw1XLc14NDOVEpkS
// SIG // ud5oL6rm48KKjCrDiyGHZr2DWFdvdb88qiaHXcoQFTyf
// SIG // hOpUwQpuxP7FSt25BxGXInzbPifRHnjsnzHJ8eYiGdvE
// SIG // s0dDmhpfoB6Q5F717nzxfatiAY/1TQve0CJWqJXNroh2
// SIG // ru66DfPkTdmg+2igrhQ7s4fBuwIDAQABo4HbMIHYMDQG
// SIG // CCsGAQUFBwEBBCgwJjAkBggrBgEFBQcwAYYYaHR0cDov
// SIG // L29jc3AudmVyaXNpZ24uY29tMBIGA1UdEwEB/wQIMAYB
// SIG // Af8CAQAwQQYDVR0fBDowODA2oDSgMoYwaHR0cDovL2Ny
// SIG // bC52ZXJpc2lnbi5jb20vVGhhd3RlVGltZXN0YW1waW5n
// SIG // Q0EuY3JsMBMGA1UdJQQMMAoGCCsGAQUFBwMIMA4GA1Ud
// SIG // DwEB/wQEAwIBBjAkBgNVHREEHTAbpBkwFzEVMBMGA1UE
// SIG // AxMMVFNBMjA0OC0xLTUzMA0GCSqGSIb3DQEBBQUAA4GB
// SIG // AEpr+epYwkQcMYl5mSuWv4KsAdYcTM2wilhu3wgpo17I
// SIG // ypMT5wRSDe9HJy8AOLDkyZNOmtQiYhX3PzchT3AxgPGL
// SIG // OIez6OiXAP7PVZZOJNKpJ056rrdhQfMqzufJ2V7duyuF
// SIG // PrWdtdnhV/++tMV+9c8MnvCX/ivTO1IbGzgn9z9KMIIE
// SIG // vzCCBCigAwIBAgIQQZGhWjl4389JZWY4HUx1wjANBgkq
// SIG // hkiG9w0BAQUFADBfMQswCQYDVQQGEwJVUzEXMBUGA1UE
// SIG // ChMOVmVyaVNpZ24sIEluYy4xNzA1BgNVBAsTLkNsYXNz
// SIG // IDMgUHVibGljIFByaW1hcnkgQ2VydGlmaWNhdGlvbiBB
// SIG // dXRob3JpdHkwHhcNMDQwNzE2MDAwMDAwWhcNMTQwNzE1
// SIG // MjM1OTU5WjCBtDELMAkGA1UEBhMCVVMxFzAVBgNVBAoT
// SIG // DlZlcmlTaWduLCBJbmMuMR8wHQYDVQQLExZWZXJpU2ln
// SIG // biBUcnVzdCBOZXR3b3JrMTswOQYDVQQLEzJUZXJtcyBv
// SIG // ZiB1c2UgYXQgaHR0cHM6Ly93d3cudmVyaXNpZ24uY29t
// SIG // L3JwYSAoYykwNDEuMCwGA1UEAxMlVmVyaVNpZ24gQ2xh
// SIG // c3MgMyBDb2RlIFNpZ25pbmcgMjAwNCBDQTCCASIwDQYJ
// SIG // KoZIhvcNAQEBBQADggEPADCCAQoCggEBAL687rx+74Pr
// SIG // 4DdP+wMQOL4I0ox9nfqSfxkMwmvuQlKM3tMcSBMl6sFj
// SIG // evlRZe7Tqjv18JScK/vyZtQk2vf1n24ZOTa80KN2CB4i
// SIG // JyRsOJEn4oRJrhuKof0lgiwQMOhxqyjod0pR8ezN+PBU
// SIG // 1G/A420Kj9nYZI1jsi1OJ/aFDv5t4ymZ4oVHfC2Gf+hX
// SIG // j61nwjMykRMg/KkjFJptwoRLdmgE1XEsXSH6iA0m/R8t
// SIG // kSvnAVVN8m01KILf2WtcttbZqoH9X82DumOd0CL8qTtC
// SIG // abKOOrW8tJ4PXsTqLIKLKP1TCJbdtQEg0fmlGOfA7lFw
// SIG // N+G2BUhSSG846sPobHtEhLsCAwEAAaOCAaAwggGcMBIG
// SIG // A1UdEwEB/wQIMAYBAf8CAQAwRAYDVR0gBD0wOzA5Bgtg
// SIG // hkgBhvhFAQcXAzAqMCgGCCsGAQUFBwIBFhxodHRwczov
// SIG // L3d3dy52ZXJpc2lnbi5jb20vcnBhMDEGA1UdHwQqMCgw
// SIG // JqAkoCKGIGh0dHA6Ly9jcmwudmVyaXNpZ24uY29tL3Bj
// SIG // YTMuY3JsMB0GA1UdJQQWMBQGCCsGAQUFBwMCBggrBgEF
// SIG // BQcDAzAOBgNVHQ8BAf8EBAMCAQYwEQYJYIZIAYb4QgEB
// SIG // BAQDAgABMCkGA1UdEQQiMCCkHjAcMRowGAYDVQQDExFD
// SIG // bGFzczNDQTIwNDgtMS00MzAdBgNVHQ4EFgQUCPVR6Pv+
// SIG // PT1kNnxoz1t4qN+5xTcwgYAGA1UdIwR5MHehY6RhMF8x
// SIG // CzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwg
// SIG // SW5jLjE3MDUGA1UECxMuQ2xhc3MgMyBQdWJsaWMgUHJp
// SIG // bWFyeSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eYIQcLrk
// SIG // HRDZKTS2OMp7A8y6vzANBgkqhkiG9w0BAQUFAAOBgQCu
// SIG // Ohe4SntV+mRV7ECk7UlBkJmcibyvLh3KeCP5HBkPf+to
// SIG // vDLZiDje3D/TibQ/sYKW8aRauu0uJtPefAFuAAoApAaS
// SIG // EUgJQPkcGHlnIyTgu9XhUK4b9Q7d4C6BzYCjbFJPkXVV
// SIG // iroi8tLqQXWIL2NVfR5UWpVZytk0gcBfXvZ6tTCCBQkw
// SIG // ggPxoAMCAQICEErej526uUojb1I0pA35Pn4wDQYJKoZI
// SIG // hvcNAQEFBQAwgbQxCzAJBgNVBAYTAlVTMRcwFQYDVQQK
// SIG // Ew5WZXJpU2lnbiwgSW5jLjEfMB0GA1UECxMWVmVyaVNp
// SIG // Z24gVHJ1c3QgTmV0d29yazE7MDkGA1UECxMyVGVybXMg
// SIG // b2YgdXNlIGF0IGh0dHBzOi8vd3d3LnZlcmlzaWduLmNv
// SIG // bS9ycGEgKGMpMDQxLjAsBgNVBAMTJVZlcmlTaWduIENs
// SIG // YXNzIDMgQ29kZSBTaWduaW5nIDIwMDQgQ0EwHhcNMDgw
// SIG // MzIwMDAwMDAwWhcNMDkwMzIwMjM1OTU5WjCBzDELMAkG
// SIG // A1UEBhMCVVMxEzARBgNVBAgTCkNhbGlmb3JuaWExEzAR
// SIG // BgNVBAcTClNhbiBSYWZhZWwxFzAVBgNVBAoUDkF1dG9k
// SIG // ZXNrLCBJbmMuMSEwHwYDVQQLFBhQU0VCLUxpY2Vuc2lu
// SIG // ZyAmIEluc3RhbGwxPjA8BgNVBAsTNURpZ2l0YWwgSUQg
// SIG // Q2xhc3MgMyAtIE1pY3Jvc29mdCBTb2Z0d2FyZSBWYWxp
// SIG // ZGF0aW9uIHYyMRcwFQYDVQQDFA5BdXRvZGVzaywgSW5j
// SIG // LjCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEAp+6n
// SIG // nTaWIaaik4EgXpsaskB3OTSOClzOXYCXAb72SwJCpwl9
// SIG // vER/uhH7cq2P7d6UNPue0OFVpr73qgMo0/TVXms6jug1
// SIG // n+nHo55JZcMOaDDprfsuuDznAmsiMoZoAdnMO1n3ZBbp
// SIG // gXcZ6xujdhb+wllM1s165yyYM+tTZlI53s8CAwEAAaOC
// SIG // AX8wggF7MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeA
// SIG // MEAGA1UdHwQ5MDcwNaAzoDGGL2h0dHA6Ly9DU0MzLTIw
// SIG // MDQtY3JsLnZlcmlzaWduLmNvbS9DU0MzLTIwMDQuY3Js
// SIG // MEQGA1UdIAQ9MDswOQYLYIZIAYb4RQEHFwMwKjAoBggr
// SIG // BgEFBQcCARYcaHR0cHM6Ly93d3cudmVyaXNpZ24uY29t
// SIG // L3JwYTATBgNVHSUEDDAKBggrBgEFBQcDAzB1BggrBgEF
// SIG // BQcBAQRpMGcwJAYIKwYBBQUHMAGGGGh0dHA6Ly9vY3Nw
// SIG // LnZlcmlzaWduLmNvbTA/BggrBgEFBQcwAoYzaHR0cDov
// SIG // L0NTQzMtMjAwNC1haWEudmVyaXNpZ24uY29tL0NTQzMt
// SIG // MjAwNC1haWEuY2VyMB8GA1UdIwQYMBaAFAj1Uej7/j09
// SIG // ZDZ8aM9beKjfucU3MBEGCWCGSAGG+EIBAQQEAwIEEDAW
// SIG // BgorBgEEAYI3AgEbBAgwBgEBAAEB/zANBgkqhkiG9w0B
// SIG // AQUFAAOCAQEAoPt/JaNzwVvcuubHYt0M860+ntlMVoew
// SIG // XuvpZovRS8qzZTdLQDOGL4DL5GfVcC3t8YyomUYLJ7Rh
// SIG // BGhjuPyDtinUxw85rWZ+OHDkSvmPL0seDyJeUELj17qU
// SIG // JHCwJyeAErkw8vt7Tyi8XZjF2YP3PCGBYTX2s2qMTlXZ
// SIG // z6nqHnbN564AtxqBHcu4HXoKUT28fFhZEmYIANzmRaTi
// SIG // ZBYFFxaAf89H9xBSE+WqOiLP0W7FGJ6FTRyCIAkwFOfY
// SIG // Xi34nFfP62xKRrD7O2BPKI1mMlUSizqRFpooCWfjZjcw
// SIG // XWGQu6TZ9Xf+1DoLHrYbOPIjmpuTEyZtr8s94s/9eof6
// SIG // pDGCA6owggOmAgEBMIHJMIG0MQswCQYDVQQGEwJVUzEX
// SIG // MBUGA1UEChMOVmVyaVNpZ24sIEluYy4xHzAdBgNVBAsT
// SIG // FlZlcmlTaWduIFRydXN0IE5ldHdvcmsxOzA5BgNVBAsT
// SIG // MlRlcm1zIG9mIHVzZSBhdCBodHRwczovL3d3dy52ZXJp
// SIG // c2lnbi5jb20vcnBhIChjKTA0MS4wLAYDVQQDEyVWZXJp
// SIG // U2lnbiBDbGFzcyAzIENvZGUgU2lnbmluZyAyMDA0IENB
// SIG // AhBK3o+durlKI29SNKQN+T5+MAkGBSsOAwIaBQCggbQw
// SIG // GQYJKoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYB
// SIG // BAGCNwIBCzEOMAwGCisGAQQBgjcCARUwIwYJKoZIhvcN
// SIG // AQkEMRYEFI9Ql6fz8MHJJZtSt0Uw3u9RhdoIMFQGCisG
// SIG // AQQBgjcCAQwxRjBEoCaAJABBAHUAdABvAGQAZQBzAGsA
// SIG // IABDAG8AbQBwAG8AbgBlAG4AdKEagBhodHRwOi8vd3d3
// SIG // LmF1dG9kZXNrLmNvbSAwDQYJKoZIhvcNAQEBBQAEgYCd
// SIG // n/jVTtty2HqL6crpM3yOwmaHEJ5b4EhjGAxbzwxUByUg
// SIG // D9ex8uNBLqrc9LpSjGKKXNGgM+a0huwuRtdrW2Mr/VZ7
// SIG // F0iK9uyM+TR4jehgnriOP+poM4sCIVcd1FGI+S3Ehj7w
// SIG // 8gIohL1cIi2GsXWUoIdZg5c9UTJf+vCamuSZAKGCAX8w
// SIG // ggF7BgkqhkiG9w0BCQYxggFsMIIBaAIBATBnMFMxCzAJ
// SIG // BgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5j
// SIG // LjErMCkGA1UEAxMiVmVyaVNpZ24gVGltZSBTdGFtcGlu
// SIG // ZyBTZXJ2aWNlcyBDQQIQOCXX+vhhr570kOcmtdZa1TAJ
// SIG // BgUrDgMCGgUAoF0wGAYJKoZIhvcNAQkDMQsGCSqGSIb3
// SIG // DQEHATAcBgkqhkiG9w0BCQUxDxcNMDkwMjAzMjMyOTA2
// SIG // WjAjBgkqhkiG9w0BCQQxFgQU5eufUXz5id0kXlEAd2zR
// SIG // XWJdXVUwDQYJKoZIhvcNAQEBBQAEgYAayjoNeynPLJOT
// SIG // SoJJRTQfIDocVxi5MOxbqLiqoQFA3DW+KK2+WYbM8GWH
// SIG // cOAioavZQnvnoldoxPX/dKFpwX9ofvpRbm6llD0cGV5Q
// SIG // 71Tgi2YF/JPvTyrs4cXh8RxIma1ygN+GDRDdXtMOGWVU
// SIG // 4zEKGsDc+cr8+C2ISD46/h1Cew==
// SIG // End signature block
